#include <iostream>
#include <tuple>
#include <vector>
#include <cmath>

using namespace std;

typedef struct {
    int x_distance = 0;
    int y_distance = 0;
    vector<int> moves;
} Direction;

vector<int> x_vector;
vector<int> y_vector;
Direction up_dir, down_dir, left_dir, right_dir, bottom_left_dir, bottom_right_dir, top_left_dir, top_right_dir;

void update_distance(Direction& direction, int x, int y) {
    direction.x_distance += x;
    direction.y_distance += y;
}

void update_distances(int x, int y, int i) {
    if (x>0) {
        update_distance(right_dir, x, y);
        right_dir.moves.push_back(i);
    }
    else {
        update_distance(left_dir, x, y);
        left_dir.moves.push_back(i);
    }

    if (y>0) {
        update_distance(up_dir, x, y);
        up_dir.moves.push_back(i);
    }
    else {
        update_distance(down_dir, x, y);
        down_dir.moves.push_back(i);
    }

}


Direction largest_distance() {
    Direction res = up_dir;
    double max_distance = hypot(up_dir.x_distance, up_dir.y_distance);

    double right_distance = hypot(right_dir.x_distance, right_dir.y_distance);
    if (right_distance > max_distance) {
        max_distance = right_distance;
        res = right_dir;
    }

    double down_distance = hypot(down_dir.x_distance, down_dir.y_distance);
    if (down_distance > max_distance) {
        max_distance = down_distance;
        res = down_dir;
    }

    double left_distance = hypot(left_dir.x_distance, left_dir.y_distance);
    if (left_distance > max_distance) {
        max_distance = left_distance;
        res = left_dir;
    }

   return res;
}

int main() {
    int n;
    cin>>n;

    x_vector.resize(n);
    y_vector.resize(n);


    for (int i = 0; i<n; i++) {
        cin>>x_vector[i]>>y_vector[i];
        update_distances(x_vector[i], y_vector[i], i);
    }

    Direction res = largest_distance();

    cout<<res.moves.size()<<"\n";

    for (int i = 0; i<res.moves.size(); i++) {
        cout<<res.moves[i] + 1<<" ";
    }


    
}